/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.dao.vo.TestResultVO;
import com.quantumdata.sct.dao.vo.TestResultsVO;
import com.quantumdata.sct.dao.vo.TestStepResultVO;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrintableReportPanel
extends JPanel
implements Printable {
    private PageFormat thePageFormat;

    public PrintableReportPanel() {
        super(new FlowLayout());
        this.setBackground(Color.white);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        super.paint(graphics);
        return 0;
    }

    private void addTestStepResult(TestStepResultVO testStepResultVO) {
        String string = testStepResultVO.getStatus();
        String string2 = "Step (" + testStepResultVO.getStepId() + ") Result : " + string;
        this.add(new JLabel(string2));
    }

    private void addTestResult(TestResultVO testResultVO) {
        String string = "Test (" + testResultVO.getCapabilityId() + ") Result : " + testResultVO.getStatus();
        this.add(new JLabel(string));
        Iterator iterator = testResultVO.getStepresults().iterator();
        while (iterator.hasNext()) {
            this.addTestStepResult((TestStepResultVO)iterator.next());
        }
    }

    public void addTestResults(TestResultsVO testResultsVO) {
        String string = "Test Results for Unit (" + testResultsVO.getUnitSerial() + ")";
        this.add(new JLabel(string));
        Iterator iterator = testResultsVO.getStepresults().iterator();
        while (iterator.hasNext()) {
            this.addTestResult((TestResultVO)iterator.next());
        }
        this.setSize(800, 600);
    }

    public void printReport() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (this.thePageFormat == null) {
                this.thePageFormat = new PageFormat();
            }
            printerJob.setCopies(1);
            printerJob.setPrintable(this, this.thePageFormat);
            printerJob.print();
            printerJob = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageOptionPane messageOptionPane = new MessageOptionPane();
            MessageOptionPane.ShowMessage(this.getParent(), "Error printing report", "Error");
        }
    }
}

